/*
	$DOCFILE:MCCHAT.C

	Copyright (C) 1999 by Datalight, Inc.
	All Rights Reserved.

	A program that enables users to chat using multicast udp.

	'Chat' means to to talk and to listen. When using UDP, it means that for the
	talk side we just send a multicast message on the LAN and for the listen side
	we receive on the same UDP socket.

	This program and its functions are non-reentrant.

	$DOCHISTORY
	06/29/1999 jmb added copyright header
	12/07/1999 gvn converted UDPCHAT to MCCHAT
*/

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include "compiler.h"
#include "capi.h"
#include "udpchat.pt"

#define CHAT_PORT 33
#define BUF_SIZE 200
#define NAME_LEN	20	//my name

static char rgcKeyBuf[BUF_SIZE];	//for editing
static int iKeyCount = 0; 			//number of characters in keybuf
static NET_ADDR sNetAddr; 			//general use

/*
Sit in a loop and check for two things:
1. If any data was received from the network
	If data was received, it is displayed on screen
2. If the user has entered any data
	If the character entered was a newline, the previously entered data is
	sent, else the character is stored in a buffer.
*/

void main(void)
{
	char rgcMyNameBuf[NAME_LEN];	//buffer containing my (arbitrary) name
	char *pMyName;				//pointer to it
	int iMaxInput;				//maximum no of bytes before we must send (to keep all in buffer)
	char rgcBuf[BUF_SIZE];	//general buffer, used for sending and receiving
	int iSock;					//socket for receiving and sending packets
	int iLength;				//Length of string read or written
	char cCh;         		//Character read
	char cMoreInfo;			//Whether or not to display additional information
	WORD wNoMCEcho;			// Suppress display of own messages
	DWORD dwGroupAddress;   // Group IP address to use

	printf("Sockets UDP Chat client\n");
	printf("Copyright (C) 1999 Datalight, Inc.\nAll Rights Reserved\n\n");

	//get user name and set variables accordingly
	printf("Enter your name (send with all your messages):");
	rgcMyNameBuf[0] = NAME_LEN - 2;
	pMyName = cgets(rgcMyNameBuf);
	iMaxInput = BUF_SIZE - rgcMyNameBuf[1] - 10;

	//get more info option
	printf("\nDo you want to see the ip addresses of senders? [Y]/N");
	rgcBuf[0] = 2;
	cgets(rgcBuf);
	cMoreInfo = (toupper(rgcBuf[2]) == 'N' ? 0 : 1);
	printf("\nDo you want to suppress your own messages? [Y]/N");
	rgcBuf[0] = 2;
	cgets(rgcBuf);
	wNoMCEcho = (toupper(rgcBuf[2]) == 'N' ? 0 : NET_FLG_MC_NOECHO);


	printf("\nPress Alt-X to exit\n");

	if ((dwGroupAddress = ResolveName("229.1.2.3", rgcBuf, BUF_SIZE)) == 0)
		Aprintf("Error on ResolveName(): %s\n", Err(iNetErrNo));
	// tell IP that we want to receive multicast datagrams
	// on the default interface
	if (JoinGroup(dwGroupAddress,0) < 0)
		Aprintf("Error on JoinGroup(): %s\n", Err(iNetErrNo));

	sNetAddr.dwRemoteHost = dwGroupAddress;
	sNetAddr.wRemotePort = CHAT_PORT;
	sNetAddr.wLocalPort = CHAT_PORT;

	if ((iSock = GetSocket()) < 0)
	{
		Aprintf("Error on GetSocket(): %s\n",Err(iNetErrNo));
		return;
	}
	if (SetSocketOption(iSock, 0, NET_OPT_NON_BLOCKING, 1, 1) < 0)
	{
		Aprintf("Error on SetSocketOpt(): %s\n",Err(iNetErrNo));
		return;
	}
	if (ConnectSocket(iSock, DATA_GRAM, &sNetAddr) < 0)
	{
		Aprintf("Error on ConnectSocket(): %s\n",Err(iNetErrNo));
		return;
	}
	Aprintf("Socket successfully created\n");

	// tell the world I'm on the air
	iLength = sprintf(rgcBuf, "%s came on the air", pMyName);
	if (WriteSocket(iSock, rgcBuf, iLength, wNoMCEcho) < 0)//error
		Aprintf("Error on Sending %d bytes: %s\n",iLength, Err(iNetErrNo));

	while (1)
	{
		// see if we received data
		sNetAddr.dwRemoteHost = 0l;
		iLength = ReadSocket(iSock, rgcBuf, BUF_SIZE, &sNetAddr, 0);
		if (iNetErrNo != 0 && iNetErrNo != ERR_WOULD_BLOCK)
			Aprintf("Error on Netread: %s\n", Err(iNetErrNo));
		if (iLength > 0)
		{
			rgcBuf[iLength] = 0;
			//no color now l = sNetAddr.dwRemoteHost & 0xff;//some color identifing host
			if (cMoreInfo)	//give the sender's ip address as well
				Aprintf("From %s - ", WriteName(&sNetAddr));
			Aprintf("%s\n",rgcBuf);
		}
		if (kbhit())
		{
			switch(cCh = getche())
			{
			case 0:						// function key
				if ((cCh = getch()) == 45)	// Alt-X  exit
				{
					ReleaseSocket(iSock);
					LeaveGroup(dwGroupAddress,0);
					return;
				}
				if (cCh == 16)	// Alt-Q generate query
				{
					JoinGroup(0,0);
				}
				break;
			default:
				if (iKeyCount < iMaxInput)
				{
					rgcKeyBuf[iKeyCount++] = cCh;
					break;
				}
				//fall thru
			case '\r':
			//case '\n':
				putch('\n');
				if (iKeyCount == 0)	//nothing to do
					break;
				//everyone should identify himself
				rgcKeyBuf[iKeyCount] = 0;
				iLength = sprintf(rgcBuf, "%s: %s", pMyName, rgcKeyBuf);
				//broadcast data
				if (WriteSocket(iSock, rgcBuf, iLength, wNoMCEcho) < 0)//error
					Aprintf("Error on NetWrite %d bytes: %s\n", iLength, Err(iNetErrNo));
				iKeyCount = 0;
				break;
			}
		}
	}
}

/*
Create a human understandable string from a Sockets error code

Argument:
	uErrCode - The sockets error code

Returns:
	A pointer to the (static) string representation of the error
*/

char *Err(unsigned uErrCode)
{
	static char rgcUnk[30];
	static char *rgszErrs[] =
	{
		"NoErr",
		"InUse",
		"DOSErr",
		"NoMem",
		"NotNetconn",
		"IllegalOp",
		"BadPkt",
		"NoHost",
		"CantOpen",
		"NetUnreachable",
		"HostUnreachable",
		"ProtUnreachable",
		"PortUnreachable",
		"TimeOut",
		"HostUnknown",
		"NoServers",
		"ServerErr",
		"BadFormat",
		"BadArg",
		"EOF",
		"Reset",
		"WouldBlock",
		"UnBound",
		"NoDesc",
		"BadSysCall",
		"CantBroadcast",
		"NotEstab",
		"ReEntry",
	};

	if (uErrCode == ERR_API_NOT_LOADED)
		return "Sockets API not loaded";
	if ((uErrCode & 0xff) > ERR_RE_ENTRY)
	{
		sprintf(rgcUnk,"Unknown error 0x%04X",uErrCode);
		return rgcUnk;
	}
	return rgszErrs[uErrCode & 0xff];
}


/*
Show data on screen.

For now we just use vprintf to print the data and reprint any stuff that was
being edited.

Later we may put each person's data in a seperate block on screen, or whatever
seems fancy.

Arguments:
	Format and eclipse - Exactly the same as for prinf().
*/
void Aprintf (char *pFormat, ...)
{
	va_list pArgs;

	if (iKeyCount)	//data been edited, start on newline
		printf("\n");

	va_start(pArgs, pFormat);
	vprintf(pFormat, pArgs);
	va_end(pArgs);

	//print the old edited stuff (if any)
	if (iKeyCount)
	{
		rgcKeyBuf[iKeyCount] = 0;
		printf("%s", rgcKeyBuf);
	}
}

/*
Create a string representation of the IP address and port, in the form
	a.b.c.d:port, eg 196.10.180.3:1400.
Max length is 22 bytes.

Arguments:
	psAddr - pointer to NET_ADDR structure containing address of host.

Returns:
	Pointer to (static) array containing null-terminated string.
*/
static char *WriteName(NET_ADDR *psAddr)
{
	static char rgcName[22];

	sprintf(rgcName, "%u.%u.%u.%u:%u",
		((BYTE *)&psAddr->dwRemoteHost)[0],
		((BYTE *)&psAddr->dwRemoteHost)[1],
		((BYTE *)&psAddr->dwRemoteHost)[2],
		((BYTE *)&psAddr->dwRemoteHost)[3],
		psAddr->wRemotePort
	);
	return rgcName;
}

